'OXCARBOX.BAS
' This program
' (i) fills in current window of ChemSketch  with the molecules
'     of general formula HO-(CH2)n-COOH, n=1-10,
' (ii) performs 3D-optimization for all them and
' (iii) mark those which contain a hydroxyl group not further than
'       3 Angstroms from a carbonyl oxygen

Const nmax=10

Function Main As String
Dim Entities (1) As Object
  Call GenerateAndAnalyze
Main="Completed OK."
End Function





Sub GenerateAndAnalyze
'Generate - optomize - depict - analyze
Dim n,i,ph,pw,l,t,w,h as Integer, r As Double
Dim Ent,Mol,Oh, Cox,O1ox,O2ox,AtomCurr,AtomPrev, Page,Diagram, Struc,Font, TBox As Object


  'Get a page
  Page=ActiveDocument.ActivePage
  'If page is not empty, create new page
  If Page.Drawings.Count>0 Then Page=ActiveDocument.AddEmpty
  'Read out page parameters
  ph=Page.GetHeight
  pw=Page.GetWidth


  'In a loop ....

  For n=1 to nmax

    'Generate

    'Create new assembly
    Ent=Assemblies.AddEmpty
    Mol=Ent.Molecules.AddEmpty
    'Add OH (note that we will not add implicit hydrogen)
    Oh=NewAtom(8)     :       Ent.Add(Oh)
    'Add COOH
    Cox=NewAtom(6)    :       Ent.Add(Cox)
    O1ox=NewAtom(8)   :       Ent.Add(O1ox)
    O2ox=NewAtom(8)   :       Ent.Add(O2ox)
    'Make bonds
    Mol.AddBond(Cox,O1ox,2)
    Mol.AddBond(Cox,O2ox,1)
    AtomPrev=Oh
    'Add (CH2)n
    For i=1 To n
      AtomCurr=NewAtom(6)
      Mol.AddBond(AtomCurr,AtomPrev,1)
      AtomPrev=AtomCurr
    Next i
      Mol.AddBond(AtomPrev,Cox,1)

    'Optimize a structure

    Struc=Mol.Do3DOptimize(0.1)

    'Check out the distance

    r=Struc.GetDist(Cox,Oh)
    If (r<=5.0) Then
      Cox.SetName("$")
      Oh.SetName("$")
    End If

    'Depict as a ChemSketch diagram

    Diagram=Page.Diagrams.AddEmpty
    Diagram.Depict(Struc)
    'Set diagram size to fit all diagrams to a page
    l=Int(pw/3)
    t=200+(n-1)*Int(ph/(nmax+1))
    w=Int(pw/6)
    h=Int(0.9*ph/(nmax+1))
    Diagram.SetBound(l,t,w,h)
    'Set font for atoms symbols
    Font=Diagram.GetFont
    Font.SetFontSize(24)
    Diagram.SetFont(Font)

    'Add a textbox indicating the distance 
		'carbonyl carbon ---- hydroxy oxygen
    TBox=Page.TextBoxes.AddEmpty
    TBox.SetContent("Cox---Ooh "+FStr(r,10,4))
    TBox.SetBound(l+Int(1.1*w),t+Int(h/2),w,h)


  Next n



End Sub




